/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.configurations.processor;

import com.aptana.configurations.ConfigurationsPlugin;
import com.aptana.configurations.processor.AbstractConfigurationProcessor;
import com.aptana.configurations.processor.IConfigurationProcessorDelegate;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationProcessorsRegistry {
    private static final String EXTENSION_POINT_ID = "com.aptana.configurations.configurationProcessors";
    private static final String TAG_PROCESSOR = "processor";
    private static final String TAG_DELEGATE = "delegate";
    private static final String ATT_ID = "id";
    private static final String ATT_TARGET_ID = "targetID";
    private static final String ATT_CLASS = "class";
    private static final String ATT_NAME = "name";
    private static final String ATT_CATEGORY = "category";
    private static ConfigurationProcessorsRegistry instance = null;
    private Map<String, ProcessorFactory> processors = new HashMap<String, ProcessorFactory>();
    private Map<String, Set<ProcessorFactory>> delegators = new HashMap<String, Set<ProcessorFactory>>();

    private ConfigurationProcessorsRegistry() {
        this.readExtensionRegistry();
    }

    public static ConfigurationProcessorsRegistry getInstance() {
        if (instance == null) {
            instance = new ConfigurationProcessorsRegistry();
        }
        return instance;
    }

    public AbstractConfigurationProcessor[] getConfigurationProcessors() {
        return this.processors.values().toArray(new AbstractConfigurationProcessor[this.processors.size()]);
    }

    public AbstractConfigurationProcessor getConfigurationProcessor(String id) {
        return this.processors.get(id).createProcessor();
    }

    public String[] getConfigurationProcessorIDs() {
        return this.processors.keySet().toArray(new String[this.processors.size()]);
    }

    public Set<IConfigurationProcessorDelegate> getProcessorDelegators(String processorID) {
        Set<ProcessorFactory> factories = this.delegators.get(processorID);
        if (factories != null) {
            HashSet<IConfigurationProcessorDelegate> delegatorsSet = new HashSet<IConfigurationProcessorDelegate>(factories.size());
            for (ProcessorFactory factory : factories) {
                IConfigurationProcessorDelegate delegate = factory.createProcessorDelegate();
                if (delegate == null) continue;
                delegatorsSet.add(delegate);
            }
            return delegatorsSet;
        }
        return Collections.EMPTY_SET;
    }

    private void readExtensionRegistry() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int i = 0;
        while (i < elements.length) {
            this.readElement(elements[i]);
            ++i;
        }
    }

    private void readElement(IConfigurationElement element) {
        boolean isProcessor = TAG_PROCESSOR.equals(element.getName());
        boolean isDelegate = TAG_DELEGATE.equals(element.getName());
        if (isProcessor || isDelegate) {
            String id = element.getAttribute(ATT_ID);
            if (StringUtil.isEmpty((String)id)) {
                return;
            }
            String name = element.getAttribute(ATT_NAME);
            if (StringUtil.isEmpty((String)name)) {
                return;
            }
            String clazz = element.getAttribute(ATT_CLASS);
            if (StringUtil.isEmpty((String)clazz)) {
                return;
            }
            if (isProcessor) {
                try {
                    ProcessorFactory factory = new ProcessorFactory(element);
                    this.processors.put(id, factory);
                }
                catch (Throwable e) {
                    IdeLog.logError((Plugin)ConfigurationsPlugin.getDefault(), (String)"Failed creating a configuration processor extension", (Throwable)e);
                }
            } else {
                try {
                    String targetID = element.getAttribute(ATT_TARGET_ID);
                    Set<ProcessorFactory> otherDelegates = this.delegators.get(targetID);
                    if (otherDelegates == null) {
                        otherDelegates = new HashSet<ProcessorFactory>(6);
                        this.delegators.put(targetID, otherDelegates);
                    }
                    otherDelegates.add(new ProcessorFactory(element));
                }
                catch (Throwable e) {
                    IdeLog.logError((Plugin)ConfigurationsPlugin.getDefault(), (String)"Failed creating a configuration processor extension", (Throwable)e);
                }
            }
        }
    }

    private class ProcessorFactory {
        private final IConfigurationElement element;

        public ProcessorFactory(IConfigurationElement element) {
            this.element = element;
        }

        public IConfigurationProcessorDelegate createProcessorDelegate() {
            try {
                IConfigurationProcessorDelegate delegate = (IConfigurationProcessorDelegate)this.element.createExecutableExtension(ConfigurationProcessorsRegistry.ATT_CLASS);
                delegate.setEnablement(this.getEnablementExpression());
                return delegate;
            }
            catch (Throwable t) {
                IdeLog.logError((Plugin)ConfigurationsPlugin.getDefault(), (String)"Failed creating a configuration processor delegate extension", (Throwable)t);
                return null;
            }
        }

        public AbstractConfigurationProcessor createProcessor() {
            try {
                AbstractConfigurationProcessor processor = (AbstractConfigurationProcessor)this.element.createExecutableExtension(ConfigurationProcessorsRegistry.ATT_CLASS);
                processor.setName(this.element.getAttribute(ConfigurationProcessorsRegistry.ATT_NAME));
                processor.setID(this.element.getAttribute(ConfigurationProcessorsRegistry.ATT_ID));
                String categoryStr = this.element.getAttribute(ConfigurationProcessorsRegistry.ATT_CATEGORY);
                if (categoryStr != null && categoryStr.trim().length() > 0) {
                    processor.setCategories(categoryStr.split(", "));
                }
                processor.setEnablement(this.getEnablementExpression());
                return processor;
            }
            catch (Throwable t) {
                IdeLog.logError((Plugin)ConfigurationsPlugin.getDefault(), (String)"Failed creating a configuration processor extension", (Throwable)t);
                return null;
            }
        }

        private Expression getEnablementExpression() {
            IConfigurationElement[] enablement = this.element.getChildren("enablement");
            if (enablement != null && enablement.length > 0) {
                try {
                    return ElementHandler.getDefault().create(ExpressionConverter.getDefault(), enablement[0]);
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)ConfigurationsPlugin.getDefault(), (String)"Error while creating the configuration enablement expression.", (Throwable)e);
                    return null;
                }
            }
            return null;
        }
    }
}

